// Numus Logistics - Configuration
const CONFIG = {
  // API Configuration
  API_BASE_URL: 'https://x8ki-letl-twmt.n7.xano.io/api:pWAaQx9O',
  
  // Google Maps API Key (for address autocomplete and maps)
  GOOGLE_MAPS_API_KEY: 'YOUR_GOOGLE_MAPS_API_KEY',
  
  // App Settings
  APP_NAME: 'Numus Logistics',
  APP_VERSION: '1.0.0',
  
  // Pagination defaults
  DEFAULT_PAGE_SIZE: 20,
  
  // Polling intervals (in milliseconds)
  DASHBOARD_REFRESH_INTERVAL: 30000, // 30 seconds
  DRIVER_LOCATION_REFRESH_INTERVAL: 10000, // 10 seconds
  
  // Order statuses with labels and colors
  ORDER_STATUSES: {
    pending: { label: 'Pending', color: '#f59e0b', bgColor: '#fef3c7' },
    assigned: { label: 'Assigned', color: '#3b82f6', bgColor: '#dbeafe' },
    pickup_started: { label: 'Pickup Started', color: '#8b5cf6', bgColor: '#ede9fe' },
    picked_up: { label: 'Picked Up', color: '#6366f1', bgColor: '#e0e7ff' },
    in_transit: { label: 'In Transit', color: '#0ea5e9', bgColor: '#e0f2fe' },
    out_for_delivery: { label: 'Out for Delivery', color: '#14b8a6', bgColor: '#ccfbf1' },
    delivered: { label: 'Delivered', color: '#22c55e', bgColor: '#dcfce7' },
    cancelled: { label: 'Cancelled', color: '#ef4444', bgColor: '#fee2e2' }
  },
  
  // Driver statuses
  DRIVER_STATUSES: {
    available: { label: 'Available', color: '#22c55e', bgColor: '#dcfce7' },
    on_delivery: { label: 'On Delivery', color: '#f59e0b', bgColor: '#fef3c7' },
    offline: { label: 'Offline', color: '#6b7280', bgColor: '#f3f4f6' }
  },
  
  // Vehicle types
  VEHICLE_TYPES: {
    bike: { label: 'Motorcycle', icon: '🏍️' },
    car: { label: 'Car', icon: '🚗' },
    van: { label: 'Van', icon: '🚐' },
    truck: { label: 'Truck', icon: '🚛' }
  },
  
  // Route categories
  ROUTE_CATEGORIES: {
    local: 'Local Delivery',
    intercity: 'Intercity',
    express: 'Express',
    same_day: 'Same Day',
    next_day: 'Next Day'
  },
  
  // Pricing types
  PRICING_TYPES: {
    flat: 'Flat Rate',
    per_km: 'Per Kilometer',
    per_kg: 'Per Kilogram',
    dynamic: 'Dynamic (Distance + Weight)'
  },
  
  // Currency
  CURRENCY: {
    code: 'NGN',
    symbol: '₦',
    locale: 'en-NG'
  }
};

// Freeze config to prevent modifications
Object.freeze(CONFIG);
Object.freeze(CONFIG.ORDER_STATUSES);
Object.freeze(CONFIG.DRIVER_STATUSES);
Object.freeze(CONFIG.VEHICLE_TYPES);
Object.freeze(CONFIG.ROUTE_CATEGORIES);
Object.freeze(CONFIG.PRICING_TYPES);
Object.freeze(CONFIG.CURRENCY);
